"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeuanganController = void 0;
const common_1 = require("@nestjs/common");
const auth_guard_1 = require("../guards/auth/auth.guard");
const prisma_service_1 = require("../prisma.service");
const keuangan_dto_1 = require("./keuangan.dto");
const dayjs = require("dayjs");
let KeuanganController = class KeuanganController {
    constructor(prismaService) {
        this.prismaService = prismaService;
    }
    async paginate(page, term) {
        const pageTake = 10;
        const queryCount = await this.prismaService.keuangan.count({
            where: {
                client: {
                    name: {
                        contains: term
                    }
                }
            },
        });
        const queryData = await this.prismaService.keuangan.findMany({
            where: {
                client: {
                    name: {
                        contains: term
                    }
                }
            },
            orderBy: {
                created_at: 'desc'
            },
            include: {
                client: true,
                pembayaran_vendor: {
                    include: {
                        vendor: true
                    }
                }
            },
            take: pageTake,
            skip: (page - 1) * pageTake
        });
        return {
            data: queryData,
            paginate: {
                per_page: pageTake,
                total_page: Math.round((queryCount / pageTake) + 0.4),
                count: queryCount,
                current_page: page
            }
        };
    }
    async create(body) {
        const findFirstData = await this.prismaService.keuangan.findFirst({
            where: {
                client_id: body.client_id
            }
        });
        if (findFirstData) {
            return {
                success: true,
                message: `Data Keuangan untuk Client ini sudah ada!!!`
            };
        }
        else {
            await this.prismaService.keuangan.create({
                data: {
                    nilai_kontrak: body.nilai_kontrak,
                    dp_client: body.dp_client,
                    hutang_client: body.nilai_kontrak - body.dp_client,
                    anggaran_kegiatan: body.anggaran_kegiatan,
                    vendor_terbayar: 0,
                    vendor_belum_terbayar: 0,
                    sisa_uang: body.nilai_kontrak - body.anggaran_kegiatan,
                    uang_balejanur_terpakai: body.uang_balejanur_terpakai,
                    pure_profit: 0,
                    client_id: body.client_id,
                    created_at: dayjs().add(8, 'hour').toDate(),
                    updated_at: dayjs().add(8, 'hour').toDate()
                }
            });
            return {
                success: true,
                message: `Data Keuangan Client Berhasil Ditambahkan.`
            };
        }
    }
    async update(id, body) {
        await this.prismaService.keuangan.update({
            data: { ...body, updated_at: dayjs().add(8, 'hour').toDate() },
            where: {
                id: Number(id)
            }
        });
        return {
            success: true,
            message: "Data Keuangan Berhasil Diupdate."
        };
    }
};
exports.KeuanganController = KeuanganController;
__decorate([
    (0, common_1.Post)("search-paginate"),
    __param(0, (0, common_1.Body)("page")),
    __param(1, (0, common_1.Body)("term")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, String]),
    __metadata("design:returntype", Promise)
], KeuanganController.prototype, "paginate", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [keuangan_dto_1.KeuanganCreateDto]),
    __metadata("design:returntype", Promise)
], KeuanganController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, keuangan_dto_1.KeuanganUpdateDto]),
    __metadata("design:returntype", Promise)
], KeuanganController.prototype, "update", null);
exports.KeuanganController = KeuanganController = __decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Controller)('keuangan'),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], KeuanganController);
//# sourceMappingURL=keuangan.controller.js.map