"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserController = void 0;
const common_1 = require("@nestjs/common");
const prisma_service_1 = require("../prisma.service");
const user_dto_1 = require("./user.dto");
const dayjs = require("dayjs");
let UserController = class UserController {
    constructor(prismaService) {
        this.prismaService = prismaService;
    }
    findMany() {
        return this.prismaService.user.findMany({
            where: {
                role: {
                    not: "CLIENT"
                }
            },
            orderBy: {
                full_name: 'asc'
            },
        });
    }
    async findManyUserEo() {
        return this.prismaService.user.findMany({
            where: {
                role: "TEAM EO"
            },
            orderBy: {
                full_name: "asc"
            }
        });
    }
    findManyUserClient() {
        return this.prismaService.user.findMany({
            where: {
                role: "CLIENT"
            },
            orderBy: {
                full_name: 'asc'
            }
        });
    }
    async findUnique(id) {
        return this.prismaService.user.findUnique({
            where: {
                id: Number(id)
            }
        });
    }
    async create(body) {
        await this.prismaService.user.create({
            data: { ...body, created_at: dayjs().add(8, 'hour').toDate(), updated_at: dayjs().add(8, 'hour').toDate() }
        });
        return {
            success: true,
            message: `User Data was Created.`
        };
    }
    async update(id, body) {
        if (body.password) {
            await this.prismaService.user.update({
                where: {
                    id: Number(id)
                },
                data: { ...body, updated_at: dayjs().add(8, 'hour').toDate() }
            });
            return {
                success: true,
                message: `Data User Berhasil Diupdate.`
            };
        }
        else {
            const queryFindFirst = await this.prismaService.user.findUnique({
                where: {
                    id: Number(id)
                }
            });
            await this.prismaService.user.update({
                where: {
                    id: Number(id)
                },
                data: { ...body, password: queryFindFirst.password }
            });
            return {
                success: true,
                message: `Data User Berhasil Diupdate.`
            };
        }
    }
    async delete(id) {
        await this.prismaService.user.delete({
            where: {
                id: Number(id)
            }
        });
        return {
            success: true,
            message: `Data User Berhasil Didelete.`
        };
    }
};
exports.UserController = UserController;
__decorate([
    (0, common_1.Get)("many"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], UserController.prototype, "findMany", null);
__decorate([
    (0, common_1.Get)("many-eo"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], UserController.prototype, "findManyUserEo", null);
__decorate([
    (0, common_1.Get)("many-client"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], UserController.prototype, "findManyUserClient", null);
__decorate([
    (0, common_1.Get)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "findUnique", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [user_dto_1.UserCreateDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, user_dto_1.UserUpdateDto]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], UserController.prototype, "delete", null);
exports.UserController = UserController = __decorate([
    (0, common_1.Controller)('user'),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], UserController);
//# sourceMappingURL=user.controller.js.map