"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilesController = void 0;
const common_1 = require("@nestjs/common");
const platform_express_1 = require("@nestjs/platform-express");
const fs_1 = require("fs");
const multer_1 = require("multer");
const path_1 = require("path");
const auth_guard_1 = require("../guards/auth/auth.guard");
let FilesController = class FilesController {
    async uploadUserImage(file) {
        const fileExtension = file.originalname.split('.').pop();
        return {
            fileName: file.filename,
            fileExtension: fileExtension
        };
    }
    async getUserImage(fileName, res) {
        return res.sendFile((0, path_1.join)(process.cwd(), "uploads/user/" + fileName));
    }
    async deleteUserImage(fileName) {
        if ((0, fs_1.existsSync)("./uploads/user/" + fileName)) {
            if (fileName != "default_user.png") {
                (0, fs_1.unlinkSync)("./uploads/user/" + fileName);
            }
        }
    }
};
exports.FilesController = FilesController;
__decorate([
    (0, common_1.Post)('user'),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.UseInterceptors)((0, platform_express_1.FileInterceptor)('user_image', {
        storage: (0, multer_1.diskStorage)({
            destination: './uploads/user',
            filename: (_, file, callback) => {
                const timestamp = Date.now();
                const fileExtension = file.originalname.split('.').pop();
                const jfifFileName = file.originalname.split('.')[0];
                if (fileExtension == 'jfif') {
                    return callback(null, `${timestamp}_${jfifFileName}.jpeg`);
                }
                else {
                    return callback(null, `${timestamp}_${file.originalname}`);
                }
            }
        })
    })),
    __param(0, (0, common_1.UploadedFile)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Object]),
    __metadata("design:returntype", Promise)
], FilesController.prototype, "uploadUserImage", null);
__decorate([
    (0, common_1.Get)("user/image/:filename"),
    __param(0, (0, common_1.Param)("filename")),
    __param(1, (0, common_1.Res)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, Object]),
    __metadata("design:returntype", Promise)
], FilesController.prototype, "getUserImage", null);
__decorate([
    (0, common_1.Delete)("user/delete/:filename"),
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    __param(0, (0, common_1.Param)("filename")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], FilesController.prototype, "deleteUserImage", null);
exports.FilesController = FilesController = __decorate([
    (0, common_1.Controller)('files')
], FilesController);
//# sourceMappingURL=files.controller.js.map