"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DetailKegiatanController = void 0;
const common_1 = require("@nestjs/common");
const auth_guard_1 = require("../guards/auth/auth.guard");
const prisma_service_1 = require("../prisma.service");
const detail_kegiatan_dto_1 = require("./detail-kegiatan.dto");
const dayjs = require("dayjs");
let DetailKegiatanController = class DetailKegiatanController {
    constructor(prismaService) {
        this.prismaService = prismaService;
    }
    async findManyByClientId(id) {
        return this.prismaService.detailKegiatan.findMany({
            where: {
                client_id: Number(id)
            }
        });
    }
    async create(body) {
        await this.prismaService.detailKegiatan.create({
            data: { ...body, tanggal: dayjs(body.tanggal).add(8, 'hour').toDate(), created_at: dayjs().add(8, 'hour').toDate(), updated_at: dayjs().add(8, 'hour').toDate() }
        });
        return {
            success: true,
            message: `Data Kegiatan Berhasil Ditambahkan.`
        };
    }
    async update(id, body) {
        await this.prismaService.detailKegiatan.update({
            data: { ...body, tanggal: dayjs(body.tanggal).add(8, 'hour').toDate(), updated_at: dayjs().add(8, 'hour').toDate() },
            where: {
                id: Number(id)
            }
        });
        return {
            success: true,
            message: `Data Kegiatan Berhasil Diupdate.`
        };
    }
    async delete(id) {
        await this.prismaService.detailKegiatan.delete({
            where: {
                id: Number(id)
            }
        });
        return {
            success: true,
            message: `Data Kegiatan Berhasil Dihapus.`
        };
    }
};
exports.DetailKegiatanController = DetailKegiatanController;
__decorate([
    (0, common_1.Get)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], DetailKegiatanController.prototype, "findManyByClientId", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [detail_kegiatan_dto_1.DetailKegiatanCreateDto]),
    __metadata("design:returntype", Promise)
], DetailKegiatanController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, detail_kegiatan_dto_1.DetailKegiatanUpdateDto]),
    __metadata("design:returntype", Promise)
], DetailKegiatanController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], DetailKegiatanController.prototype, "delete", null);
exports.DetailKegiatanController = DetailKegiatanController = __decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Controller)('detail-kegiatan'),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], DetailKegiatanController);
//# sourceMappingURL=detail-kegiatan.controller.js.map