"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.VendorController = void 0;
const common_1 = require("@nestjs/common");
const auth_guard_1 = require("../guards/auth/auth.guard");
const prisma_service_1 = require("../prisma.service");
const vendor_dto_1 = require("./vendor.dto");
let VendorController = class VendorController {
    constructor(prismaService) {
        this.prismaService = prismaService;
    }
    async findMany() {
        return this.prismaService.vendor.findMany();
    }
    async create(body) {
        await this.prismaService.vendor.create({
            data: body
        });
        return {
            success: true,
            message: `Data Vendor Berhasil Ditambahkan.`
        };
    }
    async update(id, body) {
        await this.prismaService.vendor.update({
            data: body,
            where: {
                id: Number(id)
            }
        });
        return {
            success: true,
            message: `Data Vendor Berhasil Diupdate.`
        };
    }
    async delete(id) {
        await this.prismaService.vendor.delete({
            where: {
                id: Number(id)
            }
        });
        return {
            success: true,
            message: `Data Vendor Berhasil Dihapus.`
        };
    }
};
exports.VendorController = VendorController;
__decorate([
    (0, common_1.Get)("many"),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], VendorController.prototype, "findMany", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [vendor_dto_1.VendorCreateDto]),
    __metadata("design:returntype", Promise)
], VendorController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, vendor_dto_1.VendorUpdateDto]),
    __metadata("design:returntype", Promise)
], VendorController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], VendorController.prototype, "delete", null);
exports.VendorController = VendorController = __decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Controller)('vendor'),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], VendorController);
//# sourceMappingURL=vendor.controller.js.map