import { User } from '@prisma/client';
import { PrismaService } from 'src/prisma.service';
import { UserCreateDto, UserUpdateDto } from './user.dto';
import { ResponseMessage } from 'src/interface/response-message';
export declare class UserController {
    private prismaService;
    constructor(prismaService: PrismaService);
    findMany(): Promise<User[]>;
    findManyUserEo(): Promise<User[]>;
    findManyUserClient(): Promise<User[]>;
    findUnique(id: string): Promise<User>;
    create(body: UserCreateDto): Promise<ResponseMessage>;
    update(id: string, body: UserUpdateDto): Promise<ResponseMessage>;
    delete(id: string): Promise<ResponseMessage>;
}
