"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScheduleController = void 0;
const common_1 = require("@nestjs/common");
const auth_guard_1 = require("../guards/auth/auth.guard");
const prisma_service_1 = require("../prisma.service");
const schedule_dto_1 = require("./schedule.dto");
const dayjs = require("dayjs");
let ScheduleController = class ScheduleController {
    constructor(prismaService) {
        this.prismaService = prismaService;
    }
    async update(id, body) {
        await this.prismaService.schedule.update({
            data: { ...body, updated_at: dayjs().add(8, 'hour').toDate() },
            where: {
                id: Number(id)
            }
        });
        return {
            success: true,
            message: `Data Schedule Berhasil Diupdate.`
        };
    }
};
exports.ScheduleController = ScheduleController;
__decorate([
    (0, common_1.Put)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, schedule_dto_1.ScheduleUpdateDto]),
    __metadata("design:returntype", Promise)
], ScheduleController.prototype, "update", null);
exports.ScheduleController = ScheduleController = __decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Controller)('schedule'),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], ScheduleController);
//# sourceMappingURL=schedule.controller.js.map