"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PembayaranVendorController = void 0;
const common_1 = require("@nestjs/common");
const auth_guard_1 = require("../guards/auth/auth.guard");
const prisma_service_1 = require("../prisma.service");
const pembayaran_vendor_dto_1 = require("./pembayaran-vendor.dto");
const dayjs = require("dayjs");
let PembayaranVendorController = class PembayaranVendorController {
    constructor(prismaService) {
        this.prismaService = prismaService;
    }
    async findMany(id) {
        return this.prismaService.pembayaranVendor.findMany({
            orderBy: {
                created_at: "desc"
            },
            include: {
                vendor: true,
                keuangan: {
                    include: {
                        client: true
                    }
                }
            },
            where: {
                keuangan_id: Number(id)
            }
        });
    }
    async create(body) {
        if (body.dp > body.harga_total) {
            return {
                success: false,
                message: `DP Tidak Boleh Lebih Besar dari Harga Total`
            };
        }
        else {
            const totalSisa = body.harga_total - body.dp;
            await this.prismaService.pembayaranVendor.create({
                data: {
                    ...body,
                    catatan: body.catatan ? body.catatan : "",
                    total_sisa: totalSisa,
                    status: totalSisa == 0 ? 'LUNAS' : 'BELUM LUNAS',
                    created_at: dayjs().add(8, 'hour').toDate(),
                    updated_at: dayjs().add(8, 'hour').toDate()
                }
            });
            const findManyPembayaranVendorData = await this.prismaService.pembayaranVendor.findMany({
                where: {
                    keuangan_id: body.keuangan_id
                }
            });
            const vendorTerbayar = findManyPembayaranVendorData.map(d => d.harga_total).reduce((acc, val) => {
                return acc + val;
            }, 0);
            const pembayaranBelumLunas = findManyPembayaranVendorData.filter(d => d.status == "BELUM LUNAS").map(d => d.total_sisa).reduce((acc, val) => {
                return acc + val;
            }, 0);
            await this.prismaService.keuangan.update({
                data: {
                    vendor_terbayar: vendorTerbayar,
                    vendor_belum_terbayar: pembayaranBelumLunas
                },
                where: {
                    id: body.keuangan_id
                }
            });
            return {
                success: true,
                message: `Data Pembayaran Vendor Berhasil Ditambahkan.`
            };
        }
    }
    async update(id, body) {
        if (body.dp > body.harga_total) {
            return {
                success: false,
                message: `DP Tidak Boleh Lebih Besar dari Harga Total.`
            };
        }
        else {
            const totalSisa = body.harga_total - body.dp;
            await this.prismaService.pembayaranVendor.update({
                data: {
                    ...body,
                    catatan: body.catatan ? body.catatan : "",
                    total_sisa: totalSisa,
                    status: totalSisa == 0 ? "LUNAS" : "BELUM LUNAS",
                    updated_at: dayjs().add(8, 'hour').toDate(),
                    created_at: dayjs().add(8, 'hour').toDate()
                },
                where: {
                    id: Number(id)
                }
            });
            const findManyPembayaranVendorData = await this.prismaService.pembayaranVendor.findMany({
                where: {
                    keuangan_id: body.keuangan_id
                }
            });
            const vendorTerbayar = findManyPembayaranVendorData.map(d => d.harga_total).reduce((acc, val) => {
                return acc + val;
            }, 0);
            const pembayaranBelumLunas = findManyPembayaranVendorData.filter(d => d.status == "BELUM LUNAS").map(d => d.total_sisa).reduce((acc, val) => {
                return acc + val;
            }, 0);
            await this.prismaService.keuangan.update({
                data: {
                    vendor_terbayar: vendorTerbayar,
                    vendor_belum_terbayar: pembayaranBelumLunas
                },
                where: {
                    id: body.keuangan_id
                }
            });
            return {
                success: true,
                message: `Data Pembayaran Vendor Berhasil Diupdate.`
            };
        }
    }
    async delete(id) {
        const findFirstPembayaranVendor = await this.prismaService.pembayaranVendor.findUnique({
            where: {
                id: Number(id)
            }
        });
        await this.prismaService.pembayaranVendor.delete({
            where: {
                id: Number(id)
            }
        });
        const findManyPembayaranVendorData = await this.prismaService.pembayaranVendor.findMany({
            where: {
                keuangan_id: findFirstPembayaranVendor.keuangan_id
            }
        });
        const vendorTerbayar = findManyPembayaranVendorData.map(d => d.harga_total).reduce((acc, val) => {
            return acc + val;
        }, 0);
        const pembayaranBelumLunas = findManyPembayaranVendorData.filter(d => d.status == "BELUM LUNAS").map(d => d.total_sisa).reduce((acc, val) => {
            return acc + val;
        }, 0);
        await this.prismaService.keuangan.update({
            data: {
                vendor_terbayar: vendorTerbayar,
                vendor_belum_terbayar: pembayaranBelumLunas
            },
            where: {
                id: findFirstPembayaranVendor.keuangan_id
            }
        });
        return {
            success: true,
            message: `Data Pemabayran Vendor Berhasil Dihapus.`
        };
    }
};
exports.PembayaranVendorController = PembayaranVendorController;
__decorate([
    (0, common_1.Get)("many/:id"),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PembayaranVendorController.prototype, "findMany", null);
__decorate([
    (0, common_1.Post)(),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [pembayaran_vendor_dto_1.PembayaranVendorCreateDto]),
    __metadata("design:returntype", Promise)
], PembayaranVendorController.prototype, "create", null);
__decorate([
    (0, common_1.Put)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, pembayaran_vendor_dto_1.PembayaranVendorUpdateDto]),
    __metadata("design:returntype", Promise)
], PembayaranVendorController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(":id"),
    __param(0, (0, common_1.Param)("id")),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], PembayaranVendorController.prototype, "delete", null);
exports.PembayaranVendorController = PembayaranVendorController = __decorate([
    (0, common_1.UseGuards)(auth_guard_1.AuthGuard),
    (0, common_1.Controller)('pembayaran-vendor'),
    __metadata("design:paramtypes", [prisma_service_1.PrismaService])
], PembayaranVendorController);
//# sourceMappingURL=pembayaran-vendor.controller.js.map